<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> ve stopách</xsl:when>
            <xsl:otherwise> v metrech</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Parcel Layout Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title>Výpis parcel</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2>Výpis parcel</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou 
                                                <xsl:value-of select="$unit"/>, pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <div style="margin-left:0.5in;margin-right:0.5in">
                                    <xsl:for-each select="HorizontalAlignment">
                                        <table cellpadding="2" cellspacing="2">
                                            <tbody>
                                                <tr>
                                                    <th align="left" colspan="2" valign="bottom"><br/>Název trasy: </th>
                                                    <td align="left" colspan="2" valign="bottom">
                                                        <xsl:value-of select="@name"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th class="underline" valign="bottom">Body<br/>řetězce</th>
                                                    <th class="underline" valign="bottom">k<br/>bodu</th>
                                                    <th class="underline" valign="bottom">Station</th>
                                                    <th class="underline" colspan="2" valign="bottom">Odstup<br/>Vzdálenost</th>
                                                </tr>
                                                <xsl:apply-templates mode="point"/>
                                            </tbody>
                                        </table>
                                        <br/>
                                        <p lang="en"><strong>Popis <xsl:value-of select="@name"/></strong></p>
                                        <xsl:apply-templates mode="element" select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                                        <br/>
                                        <xsl:if test="@area > 0">
                                            Plocha méně nebo více 
                                            <xsl:if test="//@linearUnits = 'Imperial'">
                                                <xsl:value-of select="cif:areaFormat(number(@area))"/> st2
                                                (<xsl:value-of select="cif:acreFormat(number(@area div 43560))"/> akrů)
                                            </xsl:if>
                                            <xsl:if test="//@linearUnits = 'Metric'">
                                                <xsl:value-of select="cif:areaFormat(number(@area))"/> m2
                                                (<xsl:value-of select="cif:acreFormat(number(@area div 10000))"/> hektarů)
                                            </xsl:if>.
                                        </xsl:if>
                                        <br/><br/>
                                    </xsl:for-each>
                                </div>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Alignment Point Data -->
    <xsl:template match="HorizontalLine | HorizontalCircle | HorizontalSpiral" mode="point">
        <tr>
            <xsl:choose>
                <xsl:when test="Start/legalReference/@referenceAlignment">
                    <td class="sidepad" align="center"><xsl:value-of select="Start/legalReference/@referenceAlignment"/></td>
                    <td class="sidepad" align="right"><xsl:value-of select="Start/@name"/></td>
                    <td class="sidepad" align="center" nowrap="nowrap">
                        <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
                    </td>
                    <xsl:choose>
                        <xsl:when test="Start/legalReference/@offset &lt; 0">
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:distanceFormat(number(-1 * Start/legalReference/@offset))"/>
                            </td>
                            <td class="sidepad">L</td>
                        </xsl:when>
                        <xsl:when test="Start/legalReference/@offset &gt; 0">
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                            </td>
                            <td class="sidepad">P</td>
                        </xsl:when>
                        <xsl:when test="Start/legalReference/@offset = 0">
                            <td class="sidepad" align="right">
                                <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                            </td>
                            <td class="sidepad">&#xa0;</td>
                        </xsl:when>
                        <xsl:otherwise><td colspan="2">&#xa0;</td></xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
        </tr>
        <xsl:if test="position() = last()">
            <tr>
                <td class="sidepad" align="right"><xsl:value-of select="End/@name"/></td>
                <td class="sidepad" align="center" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </td>
                <xsl:choose>
                    <xsl:when test="End/legalReference/@offset &lt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">L</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset &gt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">P</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset = 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">&#xa0;</td>
                    </xsl:when>
                    <xsl:otherwise><td colspan="2">&#xa0;</td></xsl:otherwise>
                </xsl:choose>
            </tr>
        </xsl:if>
    </xsl:template>
    <!-- Alignment Linear Data -->
    <xsl:template match="HorizontalLine" mode="element">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Od počátečního bodu.<br/>Odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                vzdálenost
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
            </xsl:when>
            <xsl:when test="position() = last()">
                k bodu obvodu, odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                vzdálenost
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="../../@area > 0"> k počátečnímu bodu.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                k bodu obvodu, odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                vzdálenost
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Alignment Circular Data -->
    <xsl:template match="HorizontalCircle" mode="element">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Od počátečního bodu.<br/>Odtud
                podél oblouku 
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                s délkou
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>,
            </xsl:when>
            <xsl:when test="position() = last()">
                k počátečnímu bodu oblouku, odtud podél oblouku ve vzdálenosti 
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                s délkou
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="../../@area > 0"> k počátečnímu bodu.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                k počátečnímu bodu oblouku, odtud podél oblouku ve vzdálenosti
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                s délkou 
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>,
                <xsl:if test="position() = last()"> k počátečnímu bodu.</xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Alignment Spiral Data -->
    <xsl:template match="HorizontalSpiral" mode="element">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Od počátečního bodu. <br/>Odtud  
                podél přechodnice
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                s tětivou <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                s délkou
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>,
            </xsl:when>
            <xsl:when test="position() = last()">
                k počátečnímu bodu přechodnice, odsud podél přechodnice ve vzdálenosti
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                the chord of which is <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                ve vzdálenosti
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>,
                <xsl:if test="../../@area > 0"> k počátečnímu bodu.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                k počátečnímu bodu přechodnice, odstud podél přechodnice ve vzdálenosti
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                s tětivou <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                ve vzdálenosti
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>,
                <xsl:if test="position() = last()"> k počátečnímu bodu.</xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jedno uzavřené směrové řešení v <em>Zahrnout</em> v
                <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em> nebo <em>Nástroje &gt; XML 
                Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Pro kompletní výpis je vyžadována referenční trasa nastavená v <em>Referenční trasy 
                &gt; Zahrnout</em>, v <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em>.&#xa0; Není vhodný pro více referenčních tras.
            </p>
            <p class="normal1" lang="en">
                Pro kompletní výpis je potřeba, aby body směrového řešení byly pojmenované.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
